IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_PDV_VD_DEV_NCC]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC](
	[CD_CTR_NCC] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
 CONSTRAINT [PK_EST_NF_ENT_PDV_VD_DEV_NCC] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_NCC] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC] ADD  CONSTRAINT [DF_EST_NF_ENT_PDV_VD_DEV_NCC_CD_CTR_NCC]  DEFAULT ((0)) FOR [CD_CTR_NCC]


ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC] ADD  CONSTRAINT [DF_EST_NF_ENT_PDV_VD_DEV_NCC_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC] ADD  CONSTRAINT [DF_EST_NF_ENT_PDV_VD_DEV_NCC_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]


ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC] ADD  CONSTRAINT [DF_EST_NF_ENT_PDV_VD_DEV_NCC_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_PDV_VD_DEV_NCC_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])


ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC] CHECK CONSTRAINT [FK_EST_NF_ENT_PDV_VD_DEV_NCC_EST_NF_ENT]

ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_PDV_VD_DEV_NCC_PDV_VD_DEV_NCC] FOREIGN KEY([CD_CTR_NCC])
REFERENCES [dbo].[PDV_VD_DEV_NCC] ([CD_CTR_NCC])


ALTER TABLE [dbo].[EST_NF_ENT_PDV_VD_DEV_NCC] CHECK CONSTRAINT [FK_EST_NF_ENT_PDV_VD_DEV_NCC_PDV_VD_DEV_NCC]
end

